/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.doctor4t.wathe.Wathe;
import dev.doctor4t.wathe.api.GameMode;
import dev.doctor4t.wathe.api.MapEffect;
import dev.doctor4t.wathe.api.WatheGameModes;
import dev.doctor4t.wathe.api.WatheMapEffects;
import dev.doctor4t.wathe.cca.GameWorldComponent;
import dev.doctor4t.wathe.cca.MapVariablesWorldComponent;
import dev.doctor4t.wathe.command.argument.GameModeArgumentType;
import dev.doctor4t.wathe.command.argument.MapEffectArgumentType;
import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2267;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class MapVariablesCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"wathe:mapVariables").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"help").executes(context -> MapVariablesCommand.sendHelp((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"gameModeAndMapEffect").then(class_2170.method_9244((String)"gameMode", (ArgumentType)GameModeArgumentType.gameMode()).then(class_2170.method_9244((String)"mapEffect", (ArgumentType)MapEffectArgumentType.mapEffect()).executes(context -> MapVariablesCommand.setDefaultGameModeAndMapEffect((class_2168)context.getSource(), GameModeArgumentType.getGameModeArgument((CommandContext<class_2168>)context, "gameMode"), MapEffectArgumentType.getMapEffectArgument((CommandContext<class_2168>)context, "mapEffect"))))))).then(class_2170.method_9247((String)"spawnPosition").then(class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(context -> MapVariablesCommand.setPosWithOrientation((class_2168)context.getSource(), "spawnPosition", class_2277.method_9734((CommandContext)context, (String)"location"), class_2270.method_9716((CommandContext)context, (String)"rotation"), posWithOrientation -> MapVariablesCommand.getMapVarsComponent((CommandContext<class_2168>)context).setSpawnPos((MapVariablesWorldComponent.PosWithOrientation)posWithOrientation))))))).then(class_2170.method_9247((String)"spectatorSpawnPosition").then(class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(context -> MapVariablesCommand.setPosWithOrientation((class_2168)context.getSource(), "spectatorSpawnPosition", class_2277.method_9734((CommandContext)context, (String)"location"), class_2270.method_9716((CommandContext)context, (String)"rotation"), posWithOrientation -> MapVariablesCommand.getMapVarsComponent((CommandContext<class_2168>)context).setSpectatorSpawnPos((MapVariablesWorldComponent.PosWithOrientation)posWithOrientation))))))).then(class_2170.method_9247((String)"readyArea").then(class_2170.method_9244((String)"from", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2277.method_9737()).executes(context -> MapVariablesCommand.setBox((class_2168)context.getSource(), "readyArea", class_2277.method_9734((CommandContext)context, (String)"from"), class_2277.method_9734((CommandContext)context, (String)"to"), box -> MapVariablesCommand.getMapVarsComponent((CommandContext<class_2168>)context).setReadyArea((class_238)box))))))).then(class_2170.method_9247((String)"playAreaOffset").then(class_2170.method_9244((String)"offset", (ArgumentType)class_2277.method_9735((boolean)true)).executes(context -> MapVariablesCommand.setValue((class_2168)context.getSource(), "playAreaOffset", class_2338.method_49638((class_2374)class_2277.method_9736((CommandContext)context, (String)"offset")), blockPos -> MapVariablesCommand.getMapVarsComponent((CommandContext<class_2168>)context).setPlayAreaOffset((class_2382)blockPos)))))).then(class_2170.method_9247((String)"playArea").then(class_2170.method_9244((String)"from", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2277.method_9737()).executes(context -> MapVariablesCommand.setBox((class_2168)context.getSource(), "playArea", class_2277.method_9734((CommandContext)context, (String)"from"), class_2277.method_9734((CommandContext)context, (String)"to"), box -> MapVariablesCommand.getMapVarsComponent((CommandContext<class_2168>)context).setPlayArea((class_238)box))))))).then(class_2170.method_9247((String)"resetTemplateArea").then(class_2170.method_9244((String)"from", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2277.method_9737()).executes(context -> MapVariablesCommand.setBox((class_2168)context.getSource(), "resetTemplateArea", class_2277.method_9734((CommandContext)context, (String)"from"), class_2277.method_9734((CommandContext)context, (String)"to"), box -> MapVariablesCommand.getMapVarsComponent((CommandContext<class_2168>)context).setResetTemplateArea((class_238)box))))))).then(class_2170.method_9247((String)"resetPasteOffset").then(class_2170.method_9244((String)"offset", (ArgumentType)class_2277.method_9735((boolean)true)).executes(context -> MapVariablesCommand.setValue((class_2168)context.getSource(), "resetPasteOffset", class_2338.method_49638((class_2374)class_2277.method_9736((CommandContext)context, (String)"offset")), blockPos -> MapVariablesCommand.getMapVarsComponent((CommandContext<class_2168>)context).setResetPasteOffset((class_2382)blockPos)))))));
    }

    @NotNull
    private static MapVariablesWorldComponent getMapVarsComponent(CommandContext<class_2168> context) {
        return (MapVariablesWorldComponent)MapVariablesWorldComponent.KEY.get((Object)((class_2168)context.getSource()).method_9225());
    }

    private static int sendHelp(class_2168 source) {
        source.method_45068((class_2561)class_2561.method_43471((String)"wathe.map_variables.help"));
        return 1;
    }

    private static int setDefaultGameModeAndMapEffect(class_2168 source, GameMode gameMode, MapEffect mapEffect) {
        GameWorldComponent gameWorldComponent = (GameWorldComponent)GameWorldComponent.KEY.get((Object)source.method_9225());
        if (gameWorldComponent.isRunning()) {
            source.method_9213((class_2561)class_2561.method_43471((String)"game.start_error.game_running"));
            return -1;
        }
        if (gameMode == WatheGameModes.LOOSE_ENDS || gameMode == WatheGameModes.DISCOVERY || mapEffect == WatheMapEffects.HARPY_EXPRESS_SUNDOWN || mapEffect == WatheMapEffects.HARPY_EXPRESS_DAY) {
            return Wathe.executeSupporterCommand(source, () -> MapVariablesCommand.setGameModeAndMapEffect(source, gameMode, mapEffect, gameWorldComponent));
        }
        MapVariablesCommand.setGameModeAndMapEffect(source, gameMode, mapEffect, gameWorldComponent);
        return 1;
    }

    private static void setGameModeAndMapEffect(class_2168 source, GameMode gameMode, MapEffect mapEffect, GameWorldComponent gameWorldComponent) {
        gameWorldComponent.setGameMode(gameMode);
        gameWorldComponent.setMapEffect(mapEffect);
        mapEffect.initializeMapEffects(source.method_9225(), source.method_9225().method_18456());
    }

    private static <T> int setValue(class_2168 source, String valueName, T value, Consumer<T> consumer) {
        consumer.accept(value);
        source.method_45068((class_2561)class_2561.method_43469((String)"wathe.map_variables.set", (Object[])new Object[]{valueName, value.toString()}));
        return 1;
    }

    private static int setPosWithOrientation(class_2168 source, String valueName, class_2267 location, class_2267 rotation, Consumer<MapVariablesWorldComponent.PosWithOrientation> consumer) {
        class_243 absolutePos = location.method_9708(source);
        class_241 absoluteRotation = rotation.method_9709(source);
        MapVariablesCommand.setValue(source, valueName, new MapVariablesWorldComponent.PosWithOrientation(absolutePos, absoluteRotation.field_1342, absoluteRotation.field_1343), consumer);
        return 1;
    }

    private static int setBox(class_2168 source, String valueName, class_2267 from, class_2267 to, Consumer<class_238> consumer) {
        MapVariablesCommand.setValue(source, valueName, new class_238(from.method_9708(source), to.method_9708(source)), consumer);
        return 1;
    }
}

